/* - StepperDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.StepperPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class StepperDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JComboBox motorCmb;
    private JTextField velLimitTxt;
    private JTextField velActualTxt;
    private JTextField accelTxt;
    private JTextField posTargetTxt;
    private JTextField posActualTxt;
    private JTextField currentLimitTxt;
    private JTextField currentActualTxt;
    private JSlider velLimitScrl;
    private JSlider accelScrl;
    private JSlider targetPosScrl;
    private JSlider currentPosScrl;
    private JSlider currentLimitScrl;
    private JCheckBox inputArray[];
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel18;
    private JCheckBox engagedChk;
    private JCheckBox stoppedChk;
    
    /** Creates a new instance of StepperDetachListener */
    public StepperDetachListener(JFrame appFrame, JTextField attachedTxt,
                    JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
                    JTextField numMotorsTxt, JComboBox motorCmb, JTextField velLimitTxt,
                    JTextField velActualTxt, JTextField accelTxt, JTextField posTargetTxt,
                    JTextField posActualTxt, JTextField currentLimitTxt, JTextField currentActualTxt,
                    JSlider velLimitScrl, JSlider accelScrl, JSlider targetPosScrl,
                    JSlider currentPosScrl, JSlider currentLimitScrl, JCheckBox inputArray[],
                    JLabel jLabel11, JLabel jLabel12, JLabel jLabel18, JCheckBox engagedChk,
                    JCheckBox stoppedChk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.motorCmb = motorCmb;
        this.velLimitTxt = velLimitTxt;
        this.velActualTxt = velActualTxt;
        this.accelTxt = accelTxt;
        this.posTargetTxt = posTargetTxt;
        this.posActualTxt = posActualTxt;
        this.currentLimitTxt = currentLimitTxt;
        this.currentActualTxt = currentActualTxt;
        this.engagedChk = engagedChk;
        this.stoppedChk = stoppedChk;
        this.velLimitScrl = velLimitScrl;
        this.accelScrl = accelScrl;
        this.targetPosScrl = targetPosScrl;
        this.currentPosScrl = currentPosScrl;
        this.currentLimitScrl = currentLimitScrl;
        this.inputArray = inputArray;
        this.jLabel11 = jLabel11;
        this.jLabel12 = jLabel12;
        this.jLabel18 = jLabel18;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            StepperPhidget detached = (StepperPhidget)de.getSource();
            
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numMotorsTxt.setText("");
            
            motorCmb.setEnabled(false);
            motorCmb.removeAllItems();

            velLimitTxt.setText("");
            velActualTxt.setText("");
            accelTxt.setText("");
            posTargetTxt.setText("");
            posActualTxt.setText("");
            
            engagedChk.setSelected(false);
            stoppedChk.setSelected(false);
            
            accelScrl.setEnabled(false);
            accelScrl.setValue(0);
            targetPosScrl.setEnabled(false);
            targetPosScrl.setValue(0);
            engagedChk.setEnabled(false);
            
            jLabel12.setVisible(false);
            currentLimitTxt.setText("");
            currentLimitTxt.setVisible(true);
            
            jLabel18.setVisible(false);
            currentActualTxt.setText("");
            currentActualTxt.setVisible(false);
            
            jLabel11.setVisible(false);
            currentLimitScrl.setVisible(false);
            currentLimitScrl.setEnabled(false);
            
            int i;
            for(i = 0; i < 4; i++)
            {
                inputArray[i].setVisible(false);
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
